/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public final class VWStepResponseTableModel
extends AbstractTableModel
implements IVWPropertyChangeSource {
    private static final int NUM_COLUMNS = 1;
    private static final int COL_NAME = 0;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWStepDefinition m_vwStepDefinition = null;
    private Vector m_rowData = null;
    private Vector m_changedItems = null;

    public VWStepResponseTableModel(VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.m_rowData = new Vector();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void deleteItem(int nRowIndex) {
        String responseName = null;
        try {
            responseName = this.getItemAt(nRowIndex);
            if (responseName != null) {
                this.m_rowData.removeElementAt(nRowIndex);
                this.updateStepDefinition();
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(responseName);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 538);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void moveItemDown(int nRowIndex) {
        String tempString = null;
        try {
            tempString = this.getItemAt(nRowIndex);
            if (tempString != null) {
                this.m_rowData.removeElementAt(nRowIndex);
                this.m_rowData.insertElementAt(tempString, nRowIndex + 1);
                this.updateStepDefinition();
                this.fireTableRowsUpdated(nRowIndex, nRowIndex + 1);
                this.m_changedItems = null;
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 539);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void moveItemUp(int nRowIndex) {
        String tempString = null;
        try {
            tempString = this.getItemAt(nRowIndex);
            if (tempString != null) {
                this.m_rowData.removeElementAt(nRowIndex);
                this.m_rowData.insertElementAt(tempString, nRowIndex - 1);
                this.updateStepDefinition();
                this.fireTableRowsUpdated(nRowIndex - 1, nRowIndex);
                this.m_changedItems = null;
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 539);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void reinitialize(VWStepDefinition vwStepDefinition) {
        String[] responses = null;
        try {
            this.m_rowData = new Vector();
            this.m_vwStepDefinition = vwStepDefinition;
            if (vwStepDefinition != null && (responses = vwStepDefinition.getResponses()) != null) {
                for (int i = 0; i < responses.length; ++i) {
                    this.m_rowData.addElement(responses[i]);
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void notifyPropertyChange() {
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.s_nameStr;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                String name = this.getItemAt(nRowIndex);
                if (name != null) {
                    return name;
                }
                return new String();
            }
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                this.onUpdateName(aValue, nRowIndex);
            }
        }
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        try {
            if (aValue == null || !(aValue instanceof String)) {
                return;
            }
            String newName = (String)aValue;
            if (newName.length() == 0) {
                return;
            }
            String oldName = this.getItemAt(nRowIndex);
            if (oldName != null) {
                this.m_rowData.setElementAt(newName, nRowIndex);
                this.updateStepDefinition();
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(oldName);
                this.m_changedItems.addElement(newName);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 537);
            } else {
                this.m_rowData.addElement(newName);
                nRowIndex = this.m_rowData.size() - 1;
                this.updateStepDefinition();
                this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(newName);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 536);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private String getItemAt(int nRowIndex) {
        String responseName = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            responseName = (String)this.m_rowData.elementAt(nRowIndex);
        }
        return responseName;
    }

    private void updateStepDefinition() {
        Object[] responses = null;
        try {
            if (this.m_vwStepDefinition == null) {
                return;
            }
            responses = new String[this.m_rowData.size()];
            this.m_rowData.copyInto(responses);
            this.m_vwStepDefinition.setResponses((String[])responses);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

